//*********************************************************************************
// SprMake.h - Application-specific variable and function definitions
//
// Half-Life Sprite Maker - Written by David Flor, (c) 1999 Mach III Enterprises
//*********************************************************************************

#ifndef		__SPRMAKE_H__
#define		__SPRMAKE_H__

#include <windows.h>
#include "spritegn.h"
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "lbmlib2.h"

// A single bitmap
class TBMPData
{
public:
	TBMPData()		{	Clear();	}
	TBMPData(bitmap_struct *_bData);
	~TBMPData()		{	Dispose();	}

	bitmap_struct	bData;
	dspriteframe_t	fData;
	TBMPData		*next;

	void Clear(void);
	void Dispose(void);
};

// A linked list of bitmaps
class TBMPArray
{
public:
	TBMPArray()		{	Clear();	}
	~TBMPArray()	{	Dispose();	}

	TBMPData		*bmpData;
	dsprite_t		spriteData;

	void Clear(void);
	void Dispose(void);

	void AddBMPData(bitmap_struct *bData);
};

// Default transparency mode
extern int gTransparencyMode;

#endif